
/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd.h
 * $Revision: 1.1 $
 *----------------------------------------------------------------------------
 * Copyright 2003  2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *----------------------------------------------------------------------------
 * Functions:
 * 
 * 
 *----------------------------------------------------------------------------
 */
#include <linux/version.h>
#ifndef __IEGD_H__
#define __IEGD_H__

/* General customization:
 */
#define __HAVE_AGP		1
#define __MUST_HAVE_AGP		0
#define __HAVE_MTRR		0
#define __HAVE_CTX_BITMAP	1

#define DRIVER_AUTHOR		" "

#define DRIVER_NAME		"iegd"
#define DRIVER_DESC		"Intel DRM"
#define DRIVER_DATE		"20050616"

#define DRIVER_MAJOR		1
#define DRIVER_MINOR		0
#define DRIVER_PATCHLEVEL	1

#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,5)
#define KERNEL265 1
#endif

#if ((LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,11)) &&	\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,15)))
#define KERNEL2611 1
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,15)
#define KERNEL2615 1
#endif

#ifndef KERNEL265
#define KERNEL265 0
#endif

#ifndef KERNEL2611
#define KERNEL2611 0
#endif

#ifndef KERNEL2615
#define KERNEL2615 0
#endif

/* For some arcane reasons certain stuff needs to be defined in this file.
 * This is being defined in intel_interface_265.h.If not the drm won't 
 * compile properly.
 */
#include "iegd_interface_265.h"
#include "iegd_interface_2611.h"
#include "iegd_interface_2615.h"

#endif
